'use strict';

/**
 * Configure these to control smoothing and the frequency.
 */
let frequencyResolution = 16; // Must be 16, 32 or 64 per channel.
let sourceFrequency = 0; // Must be smaller than frequencyResolution. Lower values for bass, higher for treble.
let smoothingRate = 2;
let minimumScale = 0.8;
let maximumScale = 1.2;

/**
 * This creates a permanent link to the audio response data.
 */
let audioBuffer = engine.registerAudioBuffers(frequencyResolution);
var smoothValue = 0;
var initialScale;
const scaleDelta = maximumScale - minimumScale;

/**
 * @param {Vec3} value
 */
export function update() {
	let audioDelta = audioBuffer.average[sourceFrequency] - smoothValue;
	
	smoothValue += audioDelta * engine.frametime * smoothingRate;
	smoothValue = Math.min(1.0, smoothValue);

	return initialScale.multiply(smoothValue * scaleDelta + minimumScale);
}

/**
 * @param {Vec3} value
 */
export function init(value) {
	initialScale = value;
}
